*
* DNS RESOLVER FOR MARINA
* 17 MAR 15
*
NSNAMELEN DFB 0 ; DOMAIN NAME LOOKUP LENGTH
NSNAME DS 255 ; DOMAIN NAME FOR LOOKUP
NSTXID DS 2 ; TRANSACTION ID
NSREQLEN DS 2 ; LENGTH OF DNS QUERY
NSERR DFB 0 ; LOOKUP ERROR CODE
NSREMAN DFB 0 ; REMAINING ANSWERS TO PROCESS
NSSERV DFB 0 ; NAME SERVER TO USE
*
*
*
* GET HOST BY NAME
* THIS IS THE STANDARD ENTRY POINT FOR THE DNS RESOLVER.
* PTR SHOULD POINT TO A DOTTED DOMAIN NAME OR A DOTTED
* DECIMAL IP ADDRESS. IN CASE OF THE LATTER, THE 4-BYTE
* HEX REPRESENTATION OF THE IP ADDRESS IS RETURNED.
*
* PTR POINTS TO RESULT. FIRST BYTE IS LENGTH, FOLLOWED BY
* IP ADDRESS IN HEX. C=CLEAR IF NO ERROR, SET OTHERWISE.
*
* THIS ROUTINE USES THE BERKELEY SOCKETS API.
* HOWEVER, BECAUSE WE HAVE NO SELECT/PSELECT TO ALLOW US
* TO WAIT FOR AN INCOMING MESSAGE ON THE SOCKET, WE HAVE
* MAKE A WORKAROUND BY POLLING FOR INCOMING DATAGRAMS UNTIL
* WE FIND ONE THAT CONTAINS A DNS QUERY RESPONSE.
*
GETHOSTBYNAME
 JSR VERIPADDR ; WERE WE PASSED AN IP ADDRESS?
 BCS :RESOLVE ; NO, SO ATTEMPT TO RESOLVE A NAME
*
* WE WERE PASSED AN IP ADDRESS IN DOTTED DECIMAL. CONVERT
* IT TO 4 HEX BYTES AND RETURN. EASY.
*
 JSR IPTOHEX
 LDA #4  ; LENGTH OF IP ADDRESS
 STA ]DNSHOSTADDR
 LDX #3
:L LDA IPHEXTMP,X ; COPY IP ADDRESS
 STA ]DNSHOSTADDR+1,X
 DEX
 BPL :L
 LDA #<]DNSHOSTADDR
 STA PTR
 LDA #>]DNSHOSTADDR
 STA PTR+1
 CLC ; NO ERROR
 RTS
*
* WE WEREN'T GIVEN AN IP ADDRESS, SO WE ASSUME IT'S A DOMAIN
* NAME AND TRY TO RESOLVE IT.
*
:RESOLVE
 JSR DNSRESOLVE
 RTS
]DNSHOSTADDR DS 5 ; IP ADDRESS + LEN
*
*
* DNS INIT
* CLEAR OUT PARAMETERS
DNSINIT
 LDA #0
 STA NSNAMELEN
 STA NSTXID
 STA NSTXID+1
 STA NSERR
 STA NSNAME
 STA NSSERV
 RTS
*
*
* DNS RESOLVE
* PTR SHOULD POINT TO A DOTTED DOMAIN NAME (EX: EXAMPLE.COM).
* IF A TRANSACTION IS ALREADY IN PLACE, THEN THIS WILL RETURN
* WITH CARRY SET. CHECK FOR REPLIES WITH DNSREPLY.
* USES PTR2.
* TODO:
* - ADD A TIMEOUT. FOR NOW, CALL DNSABORT TO TIMEOUT.
* - ADD A NAME CACHE FOR REPEATED LOOKUPS
* - FALLBACK TO SECONDARY NAMESERVER IF NO RESPONSE FROM 1ST
* - RECURSION. FOR NOW WE RELY ON RECURSIVE NAME SERVER
*
DNSRESOLVE
 LDA NAMESERVER1 ; IS A NAMESERVER CONFIGURED?
 BNE :N ; YES, CONTINUE
 SEC  ; NO, SO ERROR
 RTS
:N LDA NSTXID
 ORA NSTXID+1
 BEQ :N2 ; NO CURRENT TRANSACTION
 SEC
 RTS ; LOOKUP IN PROGRESS
:N2
*
 JSR DNSSPLIT ; FORMAT DOMAIN NAME
 LDA NSNAME ; VALID DOMAIN NAME?
 BNE :N3
 SEC  ; NO, SO FLAG ERROR
 RTS
:N3
* OPEN A SOCKET
 LDA #<DNSSOCKPARM1
 STA PTR
 LDA #>DNSSOCKPARM1
 STA PTR+1
 JSR SOCKET
 BCC :N4
 RTS  ; SOCKET ERROR
:N4
* FILL OUT REMAINING SOCKET PARAMETER TABLES
 LDA DNSSOCKPARM1+1 ; GET SOCKET ID
 STA DNSSOCKPARM2 ; CONNECT
 STA DNSSOCKPARM3 ; SEND
 STA DNSSOCKPARM4 ; RECV
 STA DNSSOCKPARM5 ; SCLOSE
*
* CONNECT TO NAMESERVER
*
* THIS ALWAYS USES NAMESERVER1 FOR NOW.
*
 LDX #3
:DL LDA NAMESERVER1,X
 STA DNSSOCKPARM2+1,X
 DEX
 BPL :DL
*
* SET FOREIGN PORT. ALWAYS 53 FOR DNS
*
 LDA #53
 STA DNSSOCKPARM2+5
 LDA #0
 STA DNSSOCKPARM2+6
* CONNECT THIS SOCKET
 LDA #<DNSSOCKPARM2
 STA PTR
 LDA #>DNSSOCKPARM2
 STA PTR+1
 JSR CONNECT
 BCC :N5
 RTS  ; SOCKET ERROR
:N5
*
* GENERATE A QUERY TRANSACTION ID
*
 LDA RNDH
 EOR #$FF
 STA NSTXID
 INC RNDH
 LDA RNDL
 STA NSTXID+1
 INC RNDL
* FILL OUT REQUEST TEMPLATE
 LDX #0
 LDA NSTXID
 STA DNSREQ,X
 INX
 LDA NSTXID+1
 STA DNSREQ,X
* COPY DOMAIN NAME QUERY
 LDX NSNAMELEN
:NL
 LDA NSNAME,X
 STA DNSREQN,X
 DEX
 BPL :NL
* USE PTR2 TO APPEND THE TYPE AND CLASS
 LDA #<DNSREQN
 STA PTR2
 LDA #>DNSREQN
 STA PTR2+1
 LDX #0
 LDY NSNAMELEN
:NL2 LDA DNSREQT,X
 STA (PTR2),Y
 INX
 CPX #4
 BEQ :NLDONE
 INY
 BNE :NL2
 INC PTR2+1
 BNE :NL2
:NLDONE
* COMPUTE QUERY LENGTH
 LDA #16
 STA NSREQLEN
 LDA #0
 STA NSREQLEN+1
 CLC
 LDA NSNAMELEN
 ADC NSREQLEN
 STA NSREQLEN
 LDA NSREQLEN+1
 ADC #0
 STA NSREQLEN+1
*
* GET READY TO SEND ON THE SOCKET
*
 LDA #<DNSREQ
 STA DNSSOCKPARM3+1
 LDA #>DNSREQ
 STA DNSSOCKPARM3+2
 LDA NSREQLEN
 STA DNSSOCKPARM3+3
 LDA NSREQLEN+1
 STA DNSSOCKPARM3+4
 LDA #<DNSSOCKPARM3
 STA PTR
 LDA #>DNSSOCKPARM3
 STA PTR+1
 JSR SEND
 DO DEBUG
* PRINT STATUS
 LDY #0
:PL LDA MSG20,Y
 BEQ :DONE
 JSR COUT
 INY
 BNE :PL
 FIN
:DONE
 CLC ; NO ERROR
 RTS
*
* SOCKET DATA FOR DNSRESOLVE
DNSSOCKPARM1 HEX 0100 ; SOCKET
DNSSOCKPARM2 DS 7 ; CONNECT
DNSSOCKPARM3 DS 5 ; SEND
DNSSOCKPARM4 DS 5 ; RECV
DNSSOCKPARM5 DFB 1 ; SCLOSE
*
*
* DNS REQUEST TEMPLATE
DNSREQ
 HEX 0000 ; TRANSACTION ID
 HEX 0100 ; STANDARD RECURSIVE QUERY
 HEX 0001 ; ONLY 1 QUESTION
 DS 6 ; NO RESOURCE RECORDS
DNSREQN   ; SPACE FOR DOMAIN NAME
 DS 255+4 ; ...PLUS TYPE AND CLASS
DNSREQT HEX 00010001 ; COPIED INTO DNSREQN
DNSCNAMET HEX 00050001 ; TYPE/CLASS FOR CNAME
*
*
*
* DNS REPLY
* THIS IS THE MAIN ENTRY POINT FOR ALL DNS REPLIES.
* USES PTR2 INTERNALLY. PTR WILL POINT TO DATA LENGTH,
* FOLLOWED BY DATA (USUALLY THE A RECORD).
* IF CARRY SET, CHECK NSERR FOR ERROR CODE.
*
DNSREPLY
 LDA #0 ; CLEAR NSERR
 STA NSERR
 STA NSSERV
 STA NSREMAN ; CLEAR ANSWER COUNT
 LDA NSTXID ; CHECK FOR ACTIVE TRANSACTION
 ORA NSTXID+1
 BNE :N
:ERRDONE SEC  ; ERROR, SPURIOUS REPLY?
 LDA #8
 STA NSERR
 RTS
:N
* SOURCE PORT MUST BE 53
 LDY #1 ; TO LOW BYTE OF SOURCE PORT
 LDA (INPBUF),Y
 CMP #53
 BNE :ERRDONE ; WRONG PORT!
 DEY
 LDA (INPBUF),Y
 BNE :ERRDONE ; MUST BE 0
* ADVANCE POINTER TO DNS RESPONSE
 CLC
 LDA INPBUF
 ADC #8
 STA INPBUF
 STA PTR2 ; USED LATER FOR ANAME
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
 STA PTR2+1
* CHECK FOR A RESPONSE
 LDY #2
 LDA (INPBUF),Y
 BPL :ERRDONE ; MESSAGE WAS A QUERY
* CHECK TRANSACTION ID
 DEY
 LDA (INPBUF),Y
 CMP NSTXID+1
 BNE :ERRDONE
 DEY
 LDA (INPBUF),Y
 CMP NSTXID
 BNE :ERRDONE
* CLEAR TRANSACTION ID NOW
 LDA #0
 STA NSTXID
 STA NSTXID+1
* CHECK FLAGS
* ERRORS AFTER THIS POINT ARE STORED IN NSERR FOR THE
* CLIENT.
 LDY #2 ; FLAGS
 LDA (INPBUF),Y
* CHECK: MSG IS RESPONSE, STD QUERY, NO TRUNC, RD
 AND #%11111011
 CMP #%10000001
 BEQ :CF2 ; CHECK NEXT FLAG BYTE
 LDA #1 ; BAD FLAGS ERROR
 STA NSERR
 SEC
 RTS
* CHECK: RA, REPLY CODE
:CF2
 INY
 LDA (INPBUF),Y
 BMI :CF3 ; BRANCH IF RA FLAG SET
 LDA #2 ; NO RECURSION
 STA NSERR
 SEC
 RTS
:CF3
 AND #%00001111 ; MASK REPLY CODE
 BEQ :CC ; NO ERROR
* SET HIGH-BIT TO FORM NSERR CODE
 ORA #%10000000
 STA NSERR
 SEC
 RTS
* CHECK COUNTS FOR QUERIES AND ANSWERS
:CC
 INY ; QUESTION COUNT
 LDA (INPBUF),Y ; HIGH BYTE
 BNE :BADQDCOUNT ; SHOULD BE 0
 INY
 LDA (INPBUF),Y
 CMP #1 ; WE SENT 1 QUESTION
 BEQ :CC2
:BADQDCOUNT
 LDA #3
 STA NSERR
 SEC
 RTS
* CHECK ANSWER COUNT
:CC2
 INY  ; ANSWER COUNT
 LDA (INPBUF),Y
 INY
 ORA (INPBUF),Y
 BNE :CQNAME ; SENT AT LEAST 1 ANSWER
* BAD ANSWER COUNT- SENT NO ANSWERS
 LDA #4
 STA NSERR
 SEC
 RTS
* CHECK THAT THE QNAME IS THE NAME THAT WE ASKED FOR
:CQNAME
 LDA (INPBUF),Y
 STA NSREMAN ; SAVE ANSWER COUNT
 CLC
 LDA INPBUF
 ADC #12 ; POINT TO QNAME
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
*
 LDY NSNAMELEN
 DEY
:QNL LDA (INPBUF),Y
 CMP NSNAME,Y
 BNE :BADQNAME
 DEY
 BPL :QNL
* QNAME MATCHES, SO ADVANCE INPBUF AGAIN
 CLC
 LDA NSNAMELEN
 ADC INPBUF
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
 BNE :CHECKQTYPE ; ALWAYS TAKEN
:BADQNAME
 LDA #5
 STA NSERR
 SEC
 RTS
* CHECK QTYPE AND QCLASS. CURRENTLY THIS IS HARDCODED TO
* CHECK FOR TYPE A, CLASS IN.
:CHECKQTYPE
 LDY #3
:CQTL LDA (INPBUF),Y
 CMP DNSREQT,Y ; VERIFY AGAINST REQUESTED VALUES
 BNE :BADQTORQC
 DEY
 BPL :CQTL
* ADVANCE INPBUF TO CHECK THE ANSWER NAME
 CLC
 LDA INPBUF
 ADC #4
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
 BNE :CHECKANAME ; ALWAYS TAKEN
* BAD QTYPE OR QCLASS
:BADQTORQC
 LDA #6
 STA NSERR
 SEC
 RTS
* VERIFY ANSWER NAME, ACCOUNTING FOR POSSIBLE COMPRESSION
* MARKERS THAT ARE OFFSETS FROM THE HEAD OF THE DNS REPLY.
* COMPRESSION CAN ONLY OCCUR AT END OF NAME, AND IF SO,
* WE SWITCH TO USING PTR2.
:CHECKANAME
 LDY #0 ; POINT TO FIRST BYTE OF NAME
 STY ]ANAMELEN
 LDX #0 ; OFFSET IN NSNAME
:CANL LDA (INPBUF),Y
 BEQ :CANDONE ; FINISHED WITH NULL BYTE
 AND #%11000000 ; TEST FOR COMPRESSION
 CMP #%11000000
 BEQ :ANCOMP ; FOUND A COMPRESSION MARKER
 LDA (INPBUF),Y ; GET CHARACTER BACK
 CMP NSNAME,X
 BNE :BADANAME ; MISMATCH
 INY
 INX
 BPL :CANL
* COMPRESSION ONLY OCCURS AT END OF NAME
:ANCOMP
 INY ; POINT TO COMPRESSION OFFSET
 LDA (INPBUF),Y ; GET OFFSET, TO BE ADDED LATER...
 INY
 STY ]ANAMELEN ; NUMBER OF BYTES PROCESSED NOW
* NOW ADVANCE PTR2 TO ALLOW FOR FULL LENGTH NAMES
 CLC
 ADC PTR2 ; ADD COMPRESSION OFFSET
 STA PTR2
 LDA PTR2+1
 ADC #0
 STA PTR2+1
* IF X=0, THEN X REMAINS UNCHANGED, ELSE X IS INCREMENTED.
 TXA ; SET Z FLAG
 BEQ :ANCOMP2
 INX
:ANCOMP2
 LDY #0 ; THIS IS NOW USED WITH PTR2
:ANCOML LDA (PTR2),Y
 BEQ :CANDONE ; FINISHED WITH NULL BYTE
 CMP NSNAME,X
 BNE :BADANAME ; MISMATCH!
 INY
 INX
 BPL :ANCOML
* NAME IN ANSWER DIDN'T MATCH OUR QUERY
:BADANAME
 LDA #7
 STA NSERR
 SEC
 RTS
* AT THIS POINT ARE ARE DONE CHECKING THE ANSWER NAME.
* NOW WE NEED TO CHECK THE TYPE AND CLASS. IF TYPE IS
* CNAME, THEN THE A RECORD OUGHT TO APPEAR LATER IN THE
* RECORD SET. IF NOT, THEN WE NEED TO QUERY AGAIN.
* ]ANAMELEN SHOULD NOW CONTAIN LENGTH OF NAME AS IT
* APPEARS IN THE DNS RESPONSE, SO WE CAN ADVANCE INPBUF.
:CANDONE
 CLC
 LDA INPBUF
 ADC ]ANAMELEN
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
* VERIFY ATYPE AND ACLASS
:VERIFYATYPE
 LDY #3
:VATL LDA (INPBUF),Y
 CMP DNSREQT,Y
 BNE :BADATYPE
 DEY
 BPL :VATL
* NOW WE HAVE GOTTEN TO WHAT WE WANTED. ADVANCE POINTER
* PAST THE TTL AND RETURN POINTING TO DATA LEN.
 CLC
 LDA INPBUF
 ADC #8 ; POINT TO DATA LENGTH
 STA PTR
 LDA INPBUF+1
 ADC #0
 STA PTR+1
 CLC
 RTS
* BAD ANSWER TYPE
* CHECK IF IT WAS A CNAME, ELSE ERROR.
:BADATYPE
 DEC NSREMAN ; ONE LESS ANSWER REMAINING
 BEQ :NOTCNAME ; NO MORE ANSWERS TO CHECK!
 LDY #3 ; OFFSET TO ATYPE/CLASS
:CNL LDA (INPBUF),Y
 CMP DNSCNAMET,Y
 BNE :NOTCNAME
 DEY
 BPL :CNL
* AT THIS POINT WE HAVE A CNAME, SO WE NEED TO READ THE DATA
* LENGTH AND ADVANCE INPBUF TO THE NEXT ANSWER.
 LDY #8 ; HI-BYTE OF DATA LENGTH
 LDA (INPBUF),Y
 PHA
 INY  ; LO-BYTE
 CLC
 LDA INPBUF
 ADC (INPBUF),Y
 STA INPBUF
 PLA  ; GET HI-BYTE
 ADC INPBUF+1
 STA INPBUF+1
 CLC  ; NOW ADD 10 BYTES FOR T/C/TTL/DL
 LDA INPBUF
 ADC #10
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
* INPBUF IS NOW POINTING TO THE FIRST BYTE OF THE NEXT RECORD.
 LDY #0 ; NAME OFFSET
:CNL2 LDA (INPBUF),Y
 BEQ :CNAMEDONE ; FOUND END OF NAME
 AND #%11000000 ; CHECK FOR COMPRESSION
 CMP #%11000000
 BNE :CNL2NOCOMP
 INY
:CNL2NOCOMP INY
 BNE :CNL2
* NOW WE HAVE FOUND THE END OF THE NAME, SO ADVANCE INPBUF
:CNAMEDONE
 CLC
 TYA  ; LENGTH OF NAME
 ADC INPBUF
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
 JMP :VERIFYATYPE ; CHECK TYPE/CLASS OF THIS RECORD
:NOTCNAME
 LDA #9
 SEC
 RTS
]ANAMELEN DFB 0  ; LENGTH OF ANSWER NAME
*
*
*
* DNS ABORT
* CANCEL A DNS LOOKUP BY CLEARING THE TRANSACTION
* ID, NSTXID
*
DNSABORT
 LDA #0
 STA NSTXID
 STA NSTXID+1
 RTS
*
*
*
* NAME SPLIT
* SPLIT A DOMAIN NAME INTO ITS LABELS WITH LENGTHS
* TERMINATED BY A NULL LABEL.
* STRIPS HIGH BIT OFF LABELS.
* PTR SHOULD POINT TO A STRING HOLDING THE NAME.
* PROCESSING ENDS AT 255 BYTES OR A NULL BYTE.
DNSSPLIT
 LDX #0 ; NSNAME OFFSET
 LDY #0 ; PTR OFFSET
 STX ]LPOS
 STX ]NPOS
 STX NSNAME
 INX  ; MAKE SPACE FOR LABEL LENGTH
:NEXTBYTE
 LDA (PTR),Y
 BEQ :DONE ; STOP ON NULL BYTE
 AND #$7F ; STRIP HIGH BIT
 CMP #'.'
 BEQ :ADDLABEL
* CHECK FOR VALID CHARACTERS
 CMP #'-' ; HYPHEN
 BEQ :ADDCHAR
 CMP #'0'
 BCC :DONE ; OUT OF RANGE CHARACTER
 CMP #'9'+1 ; DIGITS 0-9
 BCC :ADDCHAR
 CMP #'A'
 BCC :DONE ; OUT OF RANGE CHARACTER
 CMP #'Z'+1
 BCC :ADDCHAR ; OUT OF RANGE CHARACTER
 CMP #'a'
 BCC :DONE
 CMP #'z'+1
 BCS :DONE ; OUT OF RANGE CHARACTER
* ADD CHARACTER TO CURRENT LABEL
:ADDCHAR
 STA NSNAME,X
 INX
 INY
 CPY #$FF ; AT TOTAL LENGTH LIMIT?
 BEQ :DONE ; YES
 BNE :NEXTBYTE ; MOVE ON
* ADD LABEL LENGTH
:ADDLABEL
 STX ]NPOS
 DEX  ; TO MAKE SUBTRACTION WORK
 TXA
 SEC
 SBC ]LPOS ; RESULT IS LABEL LENGTH
 LDX ]LPOS ; POSITION TO STORE LABEL LENGTH
 STA NSNAME,X ; STORE LABEL LENGTH
 LDX ]NPOS
 STX ]LPOS ; NEXT POSITION TO STORE LABEL LENGTH
 INX ; RESUME SCANNING
 INY
 BNE :NEXTBYTE
* COMPLETE LAST LABEL AND ADD NULL BYTE
:DONE
 STX ]NPOS
 DEX
 TXA
 SEC
 SBC ]LPOS
 LDX ]LPOS
 STA NSNAME,X
 LDX ]NPOS
 LDA #0 ; NULL LABEL
 STA NSNAME,X
 INX ; GET NAME LENGTH
 STX NSNAMELEN
 CLC  ; NO ERROR
 RTS
]LPOS DFB 0 ; POSITION TO STORE LABEL LENGTH
]NPOS DFB 0 ; STORE NSNAME X OFFSET HERE
*
*
* DEBUG
DNSTEST
 LDY #0
:L LDA MSG19,Y
 BEQ :N
 JSR COUT
 INY
 BNE :L
:N
 LDA #">"
 STA $33 ; PROMPT
 JSR GETLN
 LDA #0 ; PTR POINTS TO INPUT BUFFER
 STA PTR
 STA $0200,X ; PUT NULL AT END
 LDA #2
 STA PTR+1
 JSR DNSABORT ; FOR DEBUG
 JSR GETHOSTBYNAME ; LOOKUP
 RTS
*
* DNS PRINT REPLY
DNSPRNTREP
 CLC
 LDA PTR
 ADC #2 ; POINT TO ADDRESS
 STA PTR
 LDA PTR+1
 ADC #0
 STA PTR+1
 LDY #0
:L LDA MSG22,Y
 BEQ :NEXT
 JSR COUT
 INY
 BNE :L
:NEXT
 JSR PRNTIPDEC
 LDA #$8D
 JSR COUT
 RTS
